<?php
defined( 'ABSPATH' ) || die( 'Cheatin\' uh?' );

/**
 * The configuration file
 */
defined( 'HMW_REQUEST_TIME' ) || define( 'HMW_REQUEST_TIME', microtime( true ) );

if(defined( 'NONCE_KEY' )){
	defined( '_HMW_NONCE_ID_' ) || define( '_HMW_NONCE_ID_', NONCE_KEY );
}else{
	defined( '_HMW_NONCE_ID_' ) || define( '_HMW_NONCE_ID_', md5(date('Y-m-d')) );
}

//force Hide My Wp to load right after initialization
defined( 'HMW_PRIORITY' ) || define( 'HMW_PRIORITY', false );
//Force not to write the rules in config file
defined( 'HMW_RULES_IN_CONFIG' ) || define( 'HMW_RULES_IN_CONFIG', true );
//add HMW Rules in WordPress rewrite definition in htaccess
defined( 'HMW_RULES_IN_WP_RULES' ) || define( 'HMW_RULES_IN_WP_RULES', true );

//Set the PHP version ID for later use
defined( 'PHP_VERSION_ID' ) || define( 'PHP_VERSION_ID', (int) str_replace( '.', '', PHP_VERSION ) );
//Set the HMWP id for later verification
defined( 'HMW_VERSION_ID' ) || define( 'HMW_VERSION_ID', (int) str_replace( '.', '', HMW_VERSION ) );


/* No path file? error ... */
require_once( dirname( __FILE__ ) . '/paths.php' );

/* Define the record name in the Option and UserMeta tables */
define( 'HMW_OPTION', 'hmw_options' );
define( 'HMW_OPTION_SAFE', 'hmw_options_safe' );

define( 'HMW_ACTIONS', array(
	array(
		"name"    => "HMW_Controllers_Settings",
		"actions" => array(
			"action" => array(
				"hmw_settings",
				"hmw_tweakssettings",
				"hmw_confirm",
				"hmw_newpluginschange",
				"hmw_mappsettings",
				"hmw_logout",
				"hmw_abort",
				"hmw_manualrewrite",
				"hmw_advsettings",
				"hmw_backup",
				"hmw_restore",
				"hmw_support",
				"hmw_connect",
				"hmw_dont_connect"
			)
		),
		"active"  => "1"
	),
	array(
		"name"    => "HMW_Controllers_Plugins",
		"actions" => array(
			"action" => array(
				"hmw_plugin_install"
			)
		),
		"active"  => "1"
	),
	array(
		"name"    => "HMW_Controllers_SecurityCheck",
		"actions" => array(
			"action" => array(
				"hmw_securitycheck",
				"hmw_securityexclude",
				"hmw_resetexclude"
			)
		),
		"active"  => "1"
	),
	array(
		"name"    => "HMW_Controllers_Brute",
		"actions" => array(
			"action" => array(
				"hmw_brutesettings",
				"hmw_blockedips",
				"hmw_deleteip",
				"hmw_deleteallips"
			)
		),
		"active"  => "1"
	),
	array(
		"name"    => "HMW_Controllers_Widget",
		"actions" => array(
			"action" => "hmw_widget_securitycheck"
		),
		"active"  => "1"
	),
	array(
		"name"    => "HMW_Controllers_Notice",
		"actions" => array(
			"action" => array(
				"hmw_disable_notice",
				"hmw_ignore_notice"
			)
		),
		"active"  => "1"
	)
) );